<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('phone', 'password', 'name', 'email', 'd_o_b', 'last_donation_date', 'blood_type_id', 'city_id');

    public function posts()
    {
        return $this->morphedByMany('App\Models\Post', 'clientable');
    }

    public function governorates()
    {
        return $this->morphedByMany('App\Models\Governorate', 'clientable');
    }

    public function notification()
    {
        return $this->morphedByMany('App\Models\Notifiaction', 'clientable');
    }

    public function blood_types()
    {
        return $this->morphedByMany('App\Models\BloodType', 'clientable');
    }

    public function donation_requests()
    {
        return $this->morphedByMany('App\Models\DonationRequests', 'clientable');
    }

    public function cities()
    {
        return $this->morphedByMany('App\Models\City', 'clientable');
    }

}